
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  Clock.c: function to switch FRC PLL on (39.97MHz) and off (7.37MHz)
  Written by Nicholas Vinen, 2012-2013
*/

#include "Clock.h"
#include "p33Fxxxx.h"

void Clock_SetSpeed(bool Fast) {
  if( Fast ) {
    if( ((OSCCON&0x7000)>>12) != 1 ) {
      // Fosc=39.6MHz (FRC = 7.37MHz, PLLPRE=0 [N1=2], PLLPOST=0 [N2=2], PLLDIV=41 [M=43])
      PLLFBD = 41;//41;
      CLKDIVbits.PLLPRE = 0;
      CLKDIVbits.PLLPOST = 0;
      __builtin_write_OSCCONH(0x01); // switch to PLL (FRC)
      __builtin_write_OSCCONL(0x01);
    }
  } else {
    if( ((OSCCON&0x7000)>>12) != 0 ) {
      __builtin_write_OSCCONH(0x00); // switch to FRC
      __builtin_write_OSCCONL(0x01);
    }
  }
}
